"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var LanguageMenu_exports = {};
__export(LanguageMenu_exports, {
  LanguageMenu: () => LanguageMenu
});
module.exports = __toCommonJS(LanguageMenu_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var import_editor = require("@tldraw/editor");
var import_events = require("../context/events");
var import_TldrawUiMenuCheckboxItem = require("./primitives/menus/TldrawUiMenuCheckboxItem");
var import_TldrawUiMenuGroup = require("./primitives/menus/TldrawUiMenuGroup");
var import_TldrawUiMenuSubmenu = require("./primitives/menus/TldrawUiMenuSubmenu");
function LanguageMenu() {
  const editor = (0, import_editor.useEditor)();
  const trackEvent = (0, import_events.useUiEvents)();
  const currentLanguage = (0, import_editor.useValue)("locale", () => editor.user.getLocale(), [editor]);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuSubmenu.TldrawUiMenuSubmenu, { id: "help menu language", label: "menu.language", children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuGroup.TldrawUiMenuGroup, { id: "languages", children: import_editor.LANGUAGES.map(({ locale, label }) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    import_TldrawUiMenuCheckboxItem.TldrawUiMenuCheckboxItem,
    {
      id: `language-${locale}`,
      title: locale,
      label,
      checked: locale === currentLanguage,
      onSelect: () => {
        editor.user.updateUserPreferences({ locale });
        trackEvent("change-language", { source: "menu", locale });
      }
    },
    locale
  )) }) });
}
//# sourceMappingURL=LanguageMenu.js.map
